# Contributing

## Bug Reports
When filing a bug report, your issue should contain a title and a clear description of the issue. You should include as much relevant information as possible and a code sample that demonstrates the issue. The goal of a bug report is to make it easy for yourself - and others - to replicate the bug and develop a fix.

Remember, bug reports are created in the hope that others with the same problem will be able to collaborate with you on solving it. Do not expect that the bug report will automatically see any activity or that others will jump to fix it. Creating a bug report serves to help yourself and others start on the path of fixing the problem.

## Pull Requests

### New Features
For new features, please open an issue in the issue tracker to discuss the feature. We'd hate to see you put a lot of effort into something only for it to be rejected for any reason!

If you propose a new feature or drastic change to any existing functionality, please be willing to implement at least some of the code that would be needed to complete the feature.

Please open one pull request per feature. If you're wanting to add or do multiple things, send multiple pull requests.

### Coding Standards
We follow the [PSR-2 coding standard](https://github.com/php-fig/fig-standards/blob/master/accepted/PSR-2-coding-style-guide.md) - don't worry if your code isn't perfect in this regard, we will apply automatic styling when merging. Being as close as possible to the standard helps when we manually review your code.

### Tests
Please write tests for any new feature you add. Your code won't be accepted otherwise.

### Documentation and Changes
Please open a pull request within our [documentation](https://github.com/caffeinated/website) for this package with updated information regarding your update.

Also, please update the [CHANGELOG](CHANGELOG.md) with any changes, removals, or additions your pull request is making under the *Unreleased* section at the top of the file. We follow the [Keep a Changlog](https://keepachangelog.com/en/1.0.0/) conventions.

### Branches
Please create a feature branch. We will not accept pull requests from your master branch.