<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/bootstrap-toggle.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/bootstrap-select.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('css/datatables.min.css')); ?>">
<?php $__env->stopSection(); ?>

<div class="container">
    <div class="row">
        <div class="col-md-12">
            <?php echo $__env->make('partials.alert-data-error', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>

    <form method="POST" action="<?php echo e(url('inscripcion/ficha')); ?>" id="form-ficha" autocomplete="off"
        enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

        <h5><strong>Ficha de Inscripci&oacute;n:</strong></h5>
        <div class="row">
            <div class="col-md-9">
                <!-- Datos generales -->
                <div class="card card-primary card-outline elevation-2">
                    <div class="card-header"><strong>Datos generales</strong></div>
                    <div class="card-body">

                        

                        <div class="form-group row">
                            <label for="desc_tabl_det" class="col-lg-3 col-md-12 text-lg-right">Secci&oacute;n a la que
                                postula:</label>
                            <div class="col-lg-9 col-md-12">
                                <input onkeypress="return event.charCode != 34" type="text" id="desc_secc_sec"
                                    class="form-control" value="<?php echo e($seccion->desc_tabl_det ?? ''); ?>" readonly>
                                <input onkeypress="return event.charCode != 34" type="hidden" name="codi_secc_sec"
                                    value="<?php echo e($seccion->codi_tabl_det ?? ''); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="desc_espe_esp" class="col-lg-3 col-md-12 text-lg-right">Especialidad a la que
                                postula:</label>
                            <div class="col-lg-9 col-md-12">
                                <input onkeypress="return event.charCode != 34" type="text" id="desc_espe_esp"
                                    class="form-control" value="<?php echo e($especialidad->desc_tabl_det ?? ''); ?>" readonly>
                                <input onkeypress="return event.charCode != 34" type="hidden" name="codi_espe_esp"
                                    value="<?php echo e($especialidad->codi_tabl_det ?? ''); ?>">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Datos personales -->
                <div class="card card-primary card-outline elevation-2">
                    <div class="card-header"><strong>Datos personales</strong></div>
                    <div class="card-body">

                        <div class="row">
                            <div class="col-sm-6 col-xs-12">
                                <div class="form-group row">
                                    <label for="apel_pate_per" class="col-lg-6 col-md-12 text-lg-right">Apellido
                                        paterno:</label>
                                    <div class="col-lg-6 col-md-12">
                                        <input onkeypress="return event.charCode != 34"
                                            class="form-control text-uppercase" type="text" name="apel_pate_per"
                                            id="apel_pate_per"
                                            value="<?php echo e($new ? old('apel_pate_per') : $ficha->apel_pate_per); ?>"
                                            autocomplete="nope">
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xs-12">
                                <div class="form-group row">
                                    <label for="apel_mate_per" class="col-lg-6 col-md-12 text-lg-right">Apellido
                                        materno:</label>
                                    <div class="col-lg-6 col-md-12">
                                        <input onkeypress="return event.charCode != 34"
                                            class="form-control text-uppercase" type="text" name="apel_mate_per"
                                            id="apel_mate_per"
                                            value="<?php echo e($new ? old('apel_mate_per') : $ficha->apel_mate_per); ?>"
                                            autocomplete="nope">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="nomb_pers_per" class="col-lg-3 col-md-12 text-lg-right">Nombres:</label>
                            <div class="col-lg-9 col-md-12">
                                <input onkeypress="return event.charCode != 34" class="form-control text-uppercase"
                                    type="text" name="nomb_pers_per" id="nomb_pers_per"
                                    value="<?php echo e($new ? old('nomb_pers_per') : $ficha->nomb_pers_per); ?>"
                                    autocomplete="nope">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-6 col-xs-12">
                                <div class="form-group row">
                                    <label for="codi_pais_per" class="col-lg-6 col-md-12 text-lg-right">Pa&iacute;s de
                                        nacimiento:</label>
                                    <div class="col-lg-6 col-md-12">
                                        <select name="codi_pais_per" class="selectpicker form-control"
                                            id="codi_pais_per" data-live-search="true" autocomplete="nope">
                                            <option value="">Seleccione...</option>
                                            <?php if(isset($paises)): ?>
                                                <?php $__currentLoopData = $paises; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pais): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($pais->codi_tabl_det == ($new ? old('codi_pais_per') : $ficha->codi_pais_per)): ?>
                                                        <option value="<?php echo e($pais->codi_tabl_det); ?>" selected>
                                                            <?php echo e($pais->abre_tabl_det); ?></option>
                                                    <?php else: ?>
                                                        <option value="<?php echo e($pais->codi_tabl_det); ?>">
                                                            <?php echo e($pais->abre_tabl_det); ?></option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xs-12">
                                <div class="form-group row">
                                    <label for="fech_naci_fmt" class="col-lg-6 col-md-12 text-lg-right">Fecha de
                                        nacimiento:</label>
                                    <div class="col-lg-6 col-md-12">
                                        <?php if(isset($fnacimiento)): ?>
                                            <input onkeypress="return event.charCode != 34" type="text"
                                                class="form-control" id="fech_naci_fmt"
                                                value="<?php echo e(date('d/m/Y', strtotime($fnacimiento))); ?>" readonly>
                                            <input type="hidden" name="fech_naci_per"
                                                value="<?php echo e(date('Y-m-d', strtotime($fnacimiento))); ?>">
                                            <input type="hidden" name="edad_calc_pos" value="<?php echo e($edad); ?>">
                                        <?php else: ?>
                                            <input onkeypress="return event.charCode != 34" type="text"
                                                class="form-control" id="fech_naci_fmt" value="" readonly>
                                            <input type="hidden" name="fech_naci_per" value="">
                                            <input type="hidden" name="edad_calc_pos" value="">
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="form-group row" id='lugar_nacimiento' style="display: none;">
                            <label for="luga_naci_per" class="col-lg-3 col-md-12 text-lg-right">Lugar de
                                Nacimiento:</label>
                            <div class="col-lg-9 col-md-12">
                                
                                <div id="content-lugar-nacimiento" style="display: none;">
                                    <div class="input-group">
                                        <input type="text" id="luga_naci_per" class="form-control"
                                            value="<?php echo e(isset($ubigeoDom->codi_ubic_ubg) ? $ubigeoDom->codi_ubic_ubg . ' - ' . $ubigeoDom->nomb_depa_ubg . ', ' . $ubigeoDom->nomb_prov_ubg . ', ' . $ubigeoDom->nomb_dist_ubg : ''); ?>"
                                            readonly>
                                        <div class="input-group-btn">
                                            <button type="button" class="btn btn-primary"
                                                data-target="#modal-ubigeo_naci" data-toggle="modal">
                                                <span class="fas fa-search"></span>
                                            </button>
                                        </div>
                                    </div>
                                    <input type="hidden" name="ubig_naci_per" id="ubig_naci_per"
                                        value="<?php echo e($new ?: $ficha->ubig_naci_per); ?>">
                                </div>

                                <div id="content-direccion-libre" style="display: none;">
                                    <input type="text" name="direccion_libre" id="direccion_libre"
                                        class="form-control" placeholder="Ingrese la dirección">
                                </div>
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="docu_iden_per" class="col-lg-3 col-md-12 text-lg-right">Documento de
                                identidad:</label>
                            <div class="col-lg-3 col-md-6 col-sm-6">
                                <?php if(isset($tdocumento)): ?>
                                    <input type="text" id="desc_tipo_doc" class="form-control"
                                        value="<?php echo e($tdocumento->abre_tabl_det . '  ' . $ndocumento); ?>" readonly>
                                <?php else: ?>
                                    <input type="text" id="desc_tipo_doc" class="form-control" value=""
                                        readonly>
                                <?php endif; ?>
                                <input type="hidden" name="tipo_docu_per"
                                    value="<?php echo e($tdocumento->codi_tabl_det ?? ''); ?>">
                                <input type="hidden" name="nume_docu_per" value="<?php echo e($ndocumento ?? ''); ?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="luga_domi_per" class="col-lg-3 col-md-12 text-lg-right">Lugar de
                                residencia:</label>
                            <div class="col-lg-9 col-md-12">
                                <div class="input-group">
                                    <input type="text" id="luga_domi_per" class="form-control"
                                        value="<?php echo e(isset($ubigeoDom->codi_ubic_ubg) ? $ubigeoDom->codi_ubic_ubg . ' - ' . $ubigeoDom->nomb_depa_ubg . ', ' . $ubigeoDom->nomb_prov_ubg . ', ' . $ubigeoDom->nomb_dist_ubg : ''); ?>"
                                        readonly>
                                    <div class="input-group-btn">
                                        <button type="button" class="btn btn-primary" data-target="#modal-ubigeo"
                                            data-toggle="modal">
                                            <span class="fas fa-search"></span>
                                        </button>
                                    </div>
                                </div>
                                <input type="hidden" name="ubig_domi_per" id="ubig_domi_per"
                                    value="<?php echo e($new ?: $ficha->ubig_domi_per); ?>">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-6 col-xs-12">
                                <div class="form-group row">
                                    <label for="telf_fijo_per"
                                        class="col-lg-6 col-md-12 text-lg-right">Tel&eacute;fono fijo:</label>
                                    <div class="col-lg-6 col-md-12">
                                        <input onkeypress="return event.charCode != 34" class="form-control"
                                            type="text" name="telf_fijo_per" id="telf_fijo_per"
                                            value="<?php echo e($new ? old('telf_fijo_per') : $ficha->telf_fijo_per); ?>"
                                            autocomplete="nope">
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xs-12">
                                <div class="form-group row">
                                    <label for="telf_celu_per"
                                        class="col-lg-6 col-md-12 text-lg-right">Tel&eacute;fono celular:</label>
                                    <div class="col-lg-6 col-md-12">
                                        <input onkeypress="return event.charCode != 34" class="form-control"
                                            type="text" name="telf_celu_per" id="telf_celu_per"
                                            value="<?php echo e($new ? old('telf_celu_per') : $ficha->telf_celu_per); ?>"
                                            autocomplete="nope">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="tipo_prep_pos" class="col-lg-3 col-md-12 text-lg-right">&#191;D&oacute;nde se
                                prepar&oacute;&#63;:</label>
                            <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-xs-12">
                                <select class="custom-select" name="tipo_prep_pos" id="tipo_prep_pos"
                                    autocomplete="nope">
                                    <option value="">Seleccionar...</option>
                                    <option value="C"
                                        <?php echo e('C' == ($new ? old('tipo_prep_pos') : $ficha->tipo_prep_pos) ? 'selected' : ''); ?>>
                                        Cursos de extensi&oacute;n
                                    </option>
                                    <option value="A"
                                        <?php echo e('A' == ($new ? old('tipo_prep_pos') : $ficha->tipo_prep_pos) ? 'selected' : ''); ?>>
                                        Academia
                                    </option>
                                    <option value="O"
                                        <?php echo e('O' == ($new ? old('tipo_prep_pos') : $ficha->tipo_prep_pos) ? 'selected' : ''); ?>>
                                        Otros
                                    </option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group row" id="docentes1div"
                            <?php echo e('C' != ($new ? old('tipo_prep_pos') : $ficha->tipo_prep_pos) ? 'style=display:none' : ''); ?>>
                            <label for="codi_espe_adm" class="col-lg-3 col-md-12 text-lg-right">Especialidad /
                                Profesor:</label>
                            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-4 col-xs-12">
                                <select class="selectpicker form-control" name="codi_espe_adm" id="codi_espe_cex"
                                    data-live-search="true" autocomplete="nope">
                                    <option value="">Seleccionar...</option>
                                    <?php $__currentLoopData = $especialidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $espe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($espe->codi_espe_esp); ?>"
                                            <?php echo e($espe->codi_espe_esp == ($new ? old('codi_espe_adm') : $ficha->codi_espe_adm) ? 'selected' : ''); ?>>
                                            <?php echo e($espe->desc_espe_esp); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-xl-5 col-lg-5 col-md-5 col-sm-5 col-xs-12">
                                <select class="selectpicker form-control" name="codi_doce_adm" id="codi_pers_per"
                                    data-live-search="true" autocomplete="nope">
                                    <option value="">Seleccionar...</option>
                                    <?php $__currentLoopData = $docentes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($doc->codi_pers_per); ?>"
                                            <?php echo e($doc->codi_pers_per == ($new ? old('codi_doce_adm') : $ficha->codi_doce_adm) ? 'selected' : ''); ?>>
                                            <?php echo e($doc->nomb_comp_per); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="form-group row" id="docentes1div2"
                            <?php echo e('C' == ($new ? old('tipo_prep_pos') : $ficha->tipo_prep_pos) ? 'style=display:none' : ''); ?>

                            <?php echo e(null == ($new ? old('tipo_prep_pos') : $ficha->tipo_prep_pos) ? 'style=display:none' : ''); ?>>
                            <label for="leng_musi_per" class="col-lg-3 col-md-12 text-lg-right">Docente de Lenguaje
                                Musical:</label>
                            <div class="col-lg-9 col-md-12">
                                <select class="selectpicker form-control" name="leng_musi_per" id="leng_musi_per"
                                    data-live-search="true" autocomplete="nope">
                                    <option value="">Seleccionar...</option>
                                    <?php $__currentLoopData = $docentes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($doc->codi_pers_per); ?>"
                                            <?php echo e($doc->codi_pers_per == ($new ? old('leng_musi_per') : $ficha->leng_musi_per) ? 'selected' : ''); ?>>
                                            <?php echo e($doc->nomb_comp_per); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>

                        <div class="form-group row" id="docentes2div"
                            <?php echo e('C' == ($new ? old('tipo_prep_pos') : $ficha->tipo_prep_pos) ? 'style=display:none' : ''); ?>

                            <?php echo e(null == ($new ? old('tipo_prep_pos') : $ficha->tipo_prep_pos) ? 'style=display:none' : ''); ?>>
                            <label for="desc_prep_pos" class="col-lg-3 col-md-12 text-lg-right">Especialidad /
                                Profesor:</label>
                            <div class="col-lg-9 col-md-12">
                                <input onkeypress="return event.charCode != 34" class="form-control text-uppercase"
                                    type="text" name="desc_prep_pos" id="desc_prep_pos"
                                    value="<?php echo e($new ? old('desc_prep_pos') : $ficha->desc_prep_pos); ?>"
                                    autocomplete="nope">
                            </div>
                        </div>
                        <?php if($codi_secc != '05001'): ?>
                            <div class="form-group row">
                                <label for="nive_estu_adm" class="col-lg-3 col-md-12 text-lg-right">Nivel de
                                    Estudio:</label>
                                <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-xs-12">
                                    <select class="custom-select" name="nive_estu_adm" id="tipo_gra_esc"
                                        autocomplete="nope">
                                        <option value="">Seleccionar...</option>
                                        <option value="P"
                                            <?php echo e('P' == ($new ? old('nive_estu_adm') : $ficha->nive_estu_adm) ? 'selected' : ''); ?>>
                                            PRIMARIA
                                        </option>
                                        <option value="S"
                                            <?php echo e('S' == ($new ? old('nive_estu_adm') : $ficha->nive_estu_adm) ? 'selected' : ''); ?>>
                                            SECUNDARIA
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div id="grad"
                                class="col-sm-6 col-xs-12"<?php echo e(null == ($new ? old('nive_estu_adm') : $ficha->nive_estu_adm) ? 'style=display:none' : ''); ?>>
                                <div class="form-group row">
                                    <label for="telf_celu_per" class="col-lg-6 col-md-12 text-lg-right">Grado:</label>
                                    <div class="col-lg-6 col-md-12">
                                        <select id="seleccione_dis" name="grad_estu_adm" class="form-control">
                                            <option value="">Seleccionar...</option>
                                            <option class="disc" value="1"
                                                <?php echo e('1' == ($new ? old('grad_estu_adm') : $ficha->grad_estu_adm) ? 'selected' : ''); ?>>
                                                PRIMERO</option>
                                            <option class="disc" value="2"
                                                <?php echo e('2' == ($new ? old('grad_estu_adm') : $ficha->grad_estu_adm) ? 'selected' : ''); ?>>
                                                SEGUNDO</option>
                                            <option class="disc" value="3"
                                                <?php echo e('3' == ($new ? old('grad_estu_adm') : $ficha->grad_estu_adm) ? 'selected' : ''); ?>>
                                                TERCERO</option>
                                            <option class="disc" value="4"
                                                <?php echo e('4' == ($new ? old('grad_estu_adm') : $ficha->grad_estu_adm) ? 'selected' : ''); ?>>
                                                CUARTO</option>
                                            <option class="disc" value="5"
                                                <?php echo e('5' == ($new ? old('grad_estu_adm') : $ficha->grad_estu_adm) ? 'selected' : ''); ?>>
                                                QUINTO</option>
                                            <option class="disc" id="gra-sex" value="6"
                                                <?php echo e('6' == ($new ? old('grad_estu_adm') : $ficha->grad_estu_adm) ? 'selected' : ''); ?>

                                                <?php echo e('A' != ($new ? old('nive_estu_adm') : $ficha->nive_estu_adm) ? 'style=display:none' : ''); ?>>
                                                SEXTO</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Datos apoderado -->
                <?php if(isset($edad) && $edad < 18): ?>
                    <div class="card card-primary card-outline elevation-2">
                        <div class="card-header"><strong>Datos del padre o apoderado</strong></div>
                        <div class="card-body">

                            <div class="form-group row">
                                <label for="apel_nomb_apd" class="col-lg-3 col-md-12 text-lg-right">Nombres y
                                    apellidos:</label>
                                <div class="col-lg-9 col-md-12">
                                    <input onkeypress="return event.charCode != 34"
                                        class="form-control text-uppercase" type="text" name="apel_nomb_apd"
                                        id="apel_nomb_apd"
                                        value="<?php echo e($new ? old('apel_nomb_apd') : $ficha->apel_nomb_apd); ?>"
                                        autocomplete="nope">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-sm-6 col-xs-12">
                                    <div class="form-group row">
                                        <label for="nume_docu_apd"
                                            class="col-lg-6 col-md-12 text-lg-right">DNI:</label>
                                        <div class="col-lg-6 col-md-12">
                                            <input onkeypress="return event.charCode != 34" class="form-control"
                                                type="text" name="nume_docu_apd" id="nume_docu_apd"
                                                value="<?php echo e($new ? old('nume_docu_apd') : $ficha->nume_docu_apd); ?>"
                                                autocomplete="nope">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-6 col-xs-12">
                                    <div class="form-group row">
                                        <label for="telf_fijo_apd"
                                            class="col-lg-6 col-md-12 text-lg-right">Tel&eacute;fono:</label>
                                        <div class="col-lg-6 col-md-12">
                                            <input onkeypress="return event.charCode != 34" class="form-control"
                                                type="text" name="telf_fijo_apd" id="telf_fijo_apd"
                                                value="<?php echo e($new ? old('telf_fijo_apd') : $ficha->telf_fijo_apd); ?>"
                                                autocomplete="nope">
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Fotos -->
            <div class="col-md-3 col-sm-12">
                <div class="row">
                    <div class="col-md-12 col-sm-6 col-xs-12">
                        <div class="card card-primary card-outline elevation-2">
                            <div class="card-header"><strong>Foto del postulante</strong></div>
                            <div class="card-body">
                                <a tabindex="0" class="card-link" role="button" data-toggle="popover"
                                    data-trigger="focus" title="Características"
                                    data-content="La fotografía del postulante debe ser reciente, tamaño carnet, a colores y con fondo blanco."
                                    style="cursor:pointer; position:absolute;">
                                    <strong>&#91;&#63;&#93;</strong>
                                </a>
                                <center>
                                    <p style="font-size:10px">Formato permitido: jpg, png.</p>
                                    <?php if($new): ?>
                                        <img id="imgFoto1" src="<?php echo e(asset('img/sin-foto.png')); ?>"
                                            class="img-thumbnail" style="max-height:160px;">
                                    <?php else: ?>
                                        <?php if(empty($ficha->foto_post_per)): ?>
                                            <img id="imgFoto1" src="<?php echo e(asset('img/sin-foto.png')); ?>"
                                                class="img-thumbnail" style="max-height:160px;">
                                        <?php else: ?>
                                            <img id="imgFoto1"
                                                src="<?php echo e(asset('images/persons/' . $ficha->foto_post_per)); ?>"
                                                class="img-thumbnail" style="max-height:160px;">
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <label for="foto1" class="btn btn-primary m-0 mt-3 d-block"
                                        style="cursor:pointer;">
                                        <i class="fas fa-upload pr-2"></i>Seleccionar...
                                    </label>
                                    <input id="foto1" type="file" name="foto_post_per" accept=".png,.jpg"
                                        style="display:none;" data-img="imgFoto1" class="form-control">
                                    <?php if($new): ?>
                                        <input type="hidden" name="arch_foto_per" value=".">
                                    <?php else: ?>
                                        <input type="hidden" name="arch_foto_per"
                                            value="<?php echo e($ficha->foto_post_per ? $ficha->foto_post_per : '.'); ?>">
                                    <?php endif; ?>
                                </center>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 col-sm-6 col-xs-12">
                        <div class="card card-primary card-outline elevation-2">
                            <div class="card-header"><strong>Foto del documento de identidad</strong></div>
                            <div class="card-body">
                                <a tabindex="0" class="card-link" role="button" data-toggle="popover"
                                    data-trigger="focus" title="Características"
                                    data-content="La fotografía del documento de identidad del postulante debe ser de la parte frontal donde se aprecie sus datos y el número de documento."
                                    style="cursor:pointer; position:absolute;">
                                    <strong>&#91;&#63;&#93;</strong>
                                </a>
                                <center>
                                    <p style="font-size:10px">Formato permitido: jpg, png.</p>
                                    <?php if($new): ?>
                                        <img id="imgFoto2" src="<?php echo e(asset('img/sin-documento.png')); ?>"
                                            class="img-thumbnail" style="max-height:140px;">
                                    <?php else: ?>
                                        <?php if(empty($ficha->file_docu_pos)): ?>
                                            <img id="imgFoto2" src="<?php echo e(asset('img/sin-documento.png')); ?>"
                                                class="img-thumbnail" style="max-height:140px;">
                                        <?php else: ?>
                                            <img id="imgFoto2"
                                                src="<?php echo e(asset('images/persons/' . $ficha->file_docu_pos)); ?>"
                                                class="img-thumbnail" style="max-height:140px;">
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <label for="foto2" class="btn btn-primary m-0 mt-3 d-block"
                                        style="cursor:pointer;">
                                        <i class="fas fa-upload pr-2"></i>Seleccionar...
                                    </label>
                                    <input id="foto2" type="file" name="file_docu_pos" accept=".png,.jpg"
                                        style="display:none;" data-img="imgFoto2">
                                    <?php if($new): ?>
                                        <input type="hidden" name="arch_docu_per" value=".">
                                    <?php else: ?>
                                        <input type="hidden" name="arch_docu_per"
                                            value="<?php echo e($ficha->file_docu_pos ? $ficha->file_docu_pos : '.'); ?>">
                                    <?php endif; ?>
                                </center>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!----------------------------------------------------------------------->
        <!--Se agregó el campo para colocar si el participante cuenta con discapacidad en el formulario de rellenar datos--->
        <!----Discapacidad----->
        <div class="card card-primary card-outline elevation-2" id="Discapacidad">
            <div class="card-header"><strong>Datos adicionales</strong></div>
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-6 col-xs-12">
                        <div class="form-group row">
                            <label for="nume_docu_apd" class="col-lg-6 col-md-12 text-lg-right">Cuenta con alguna
                                discapacidad:</label>
                            <div class="col-lg-6 col-md-12">
                                <input type="radio" name="flag_disc_adm" id="si" value="S"
                                    <?php echo e('S' == ($new ? old('flag_disc_adm') : $ficha->flag_disc_adm) ? 'checked' : ''); ?>>
                                <label for="si">Si</label><br>
                                <input type="radio" name="flag_disc_adm" id="no" value="N"
                                    <?php echo e('N' == ($new ? old('flag_disc_adm') : $ficha->flag_disc_adm) ? 'checked' : ''); ?>>
                                <label for="no">No</label><br>
                            </div>
                        </div>
                    </div>
                </div>

                <div id="selec_disc" class="form-group row"
                    <?php echo e('S' != ($new ? old('flag_disc_adm') : $ficha->flag_disc_adm) ? 'style=display:none' : ''); ?>>
                    <label for="apel_nomb_apd" class="col-lg-3 col-md-12 text-lg-right">Seleccione:</label>
                    <div class="col-lg-9 col-md-12">
                        <select id="seleccione_dis" name="disc_soli_adm" class="form-control">
                            <option value="">Seleccionar...</option>
                            <option class="disc" value="VISUAL"
                                <?php echo e('VISUAL' == ($new ? old('disc_soli_adm') : $ficha->disc_soli_adm) ? 'selected' : ''); ?>>
                                VISUAL
                            </option>
                            <option class="disc" value="T.E.A"
                                <?php echo e('T.E.A' == ($new ? old('disc_soli_adm') : $ficha->disc_soli_adm) ? 'selected' : ''); ?>>
                                T.E.A
                            </option>
                            <option class="disc" value="AUDITIVA"
                                <?php echo e('AUDITIVA' == ($new ? old('disc_soli_adm') : $ficha->disc_soli_adm) ? 'selected' : ''); ?>>
                                AUDITIVA</option>
                            <option class="disc" value="OTROS"
                                <?php echo e('OTROS' == ($new ? old('disc_soli_adm') : $ficha->disc_soli_adm) ? 'selected' : ''); ?>>
                                OTROS
                            </option>
                        </select>
                    </div>
                </div>


            </div>
        </div>

        <!----------------------------------------------------------------------->

        <hr>
        <div class="row">
            <div class="col-12">
                <div class="card card-primary card-outline elevation-2">
                    <div class="card-header">
                        <strong>Ficha de Examen de Especialidad </strong><strong style="color: red">(Revisar
                            prospecto)</strong>
                    </div>
                    <div class="card-body">
                        <?php switch($seccion->codi_tabl_det):
                            case ('05001'): ?>
                                
                                <?php switch($especialidad->codi_tabl_det):
                                    case ('04020'): ?>
                                        
                                        <?php echo $__env->make('inscripcion.ficha.edit-repertory', [
                                            'titulo' => 'Obras a dirigir',
                                            'titulo2' => 'Obra',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <br>
                                        <?php echo $__env->make('inscripcion.ficha.edit-repertory', [
                                            'titulo' => 'Canto',
                                            'titulo2' => 'Canto',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <br>
                                    <?php break; ?>

                                    <?php case ('04090'): ?>
                                        
                                        <?php echo $__env->make('inscripcion.ficha.edit-repertory', [
                                            'titulo' => 'Obras a dirigir',
                                            'titulo2' => 'Obra',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <br>
                                    <?php break; ?>

                                    <?php case ('04016'): ?>
                                        
                                        <?php echo $__env->make('inscripcion.ficha.edit-rep-propio', [
                                            'titulo' => 'Composiciones propias',
                                            'titulo2' => 'Obra',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <br>
                                    <?php break; ?>

                                    <?php case ('04017'): ?>
                                        
                                        <?php echo $__env->make('inscripcion.ficha.edit-rep-propio', [
                                            'titulo' => 'Trabajo escrito',
                                            'titulo2' => 'Obra',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <br>

                                        <?php echo $__env->make('inscripcion.ficha.edit-repertory', [
                                            'titulo' => 'Instrumento adicional (opcional)',
                                            'titulo2' => 'Instrumento',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <br>
                                    <?php break; ?>

                                    <?php case ('04018'): ?>
                                        
                                        <?php echo $__env->make('inscripcion.ficha.edit-repertory', [
                                            'titulo' => 'Canto',
                                            'titulo2' => 'Obra',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <br>
                                    <?php break; ?>

                                    <?php default: ?>
                                        <?php echo $__env->make('inscripcion.ficha.edit-repertory', [
                                            'titulo' => 'Estudios',
                                            'titulo2' => 'Estudios',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <br>
                                <?php endswitch; ?>
                            <?php break; ?>

                            <?php case ('05002'): ?>
                                
                                <?php switch($especialidad->codi_tabl_det):
                                    case ('04113'): ?>
                                        
                                        <?php echo $__env->make('inscripcion.ficha.edit-rep-propio', [
                                            'titulo' => 'Composiciones propias',
                                            'titulo2' => 'Obra',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <br>
                                    <?php break; ?>

                                    <?php case ('04114'): ?>
                                        
                                        <?php echo $__env->make('inscripcion.ficha.edit-repertory', [
                                            'titulo' => 'Obras a dirigir',
                                            'titulo2' => 'Obras',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <br>
                                        <?php echo $__env->make('inscripcion.ficha.edit-repertory', [
                                            'titulo' => 'Canto',
                                            'titulo2' => 'Obra',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <br>
                                    <?php break; ?>

                                    <?php case ('04115'): ?>
                                        
                                        <?php echo $__env->make('inscripcion.ficha.edit-repertory', [
                                            'titulo' => 'Canto',
                                            'titulo2' => 'Obra',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <br>
                                    <?php break; ?>

                                    <?php case ('04116'): ?>
                                        
                                    <?php break; ?>

                                    <?php default: ?>
                                        <?php echo $__env->make('inscripcion.ficha.edit-repertory', [
                                            'titulo' => 'Estudios',
                                            'titulo2' => 'Estudios',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <br>
                                <?php endswitch; ?>
                            <?php break; ?>

                            <?php case ('05003'): ?>
                                
                                <?php echo $__env->make('inscripcion.ficha.edit-repertory', [
                                    'titulo' => 'Estudios',
                                    'titulo2' => 'Estudios',
                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <br>
                            <?php break; ?>

                            <?php default: ?>
                        <?php endswitch; ?>

                        <div class="form-group row">
                            <label for="tecn_post_pos_esc" class="col-lg-2 col-md-12">Escalas y arpegios:</label>
                            <div class="col-lg-10 col-md-12">
                                <input onkeypress="return event.charCode != 34" class="form-control text-uppercase"
                                    type="text" name="tecn_post_pos_esc" id="tecn_post_pos_esc"
                                    value="<?php echo e($new ? old('tecn_post_pos_esc') : $ficha->tecn_post_pos_esc); ?>"
                                    autocomplete="nope">
                            </div>
                        </div>
                        <?php echo $__env->make('inscripcion.ficha.edit-repertory', [
                            'titulo' => 'Repertorio',
                            'titulo2' => 'Repertorio',
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>


        <div class="card card-primary card-outline elevation-2">
            <div class="card-body">
                <div class="custom-control custom-checkbox mb-1">
                    <center>
                        <h4><b>Estimado postulante, revisar bien el llenado de su FICHA DE EXAMEN DE ESPECIALIDAD debido
                                a que no se podrá modificar bajo ningún motivo luego del envió de la misma.</b></h4>
                    </center><br>
                    <input type="checkbox" class="custom-control-input" id="cbox1" name="checkbox1">
                    <label class="custom-control-label" for="cbox1">DECLARO BAJO JURAMENTO LA VERACIDAD DE
                        LOS DATOS SEÑALADOS EN EL FORMULARIO DE INSCRIPCIÓN.<br>Asimismo, autorizo que toda
                        comunicación propia del presente procedimiento, se notifique a mi correo electrónico
                        (numeral 20.4, Art. 20, Ley 27444-TUO D.S. 006-2016JUS).</label>

                </div>
            </div>
        </div>
        <div class="form-group d-flex justify-content-center">
            

            <a href="" data-target="#modal-confirm" data-toggle="modal">
                <button class="btn btn-success" data-toggle="tooltip" title="Enviar ficha" id="btnEnviar" disabled>
                    <i class="fas fa-share-square pr-2"></i>Enviar ficha
                </button>
            </a>

            <?php echo $__env->make('inscripcion.ficha.partials.send', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </form>
    <!-- Modal -->
    <div class="modal fade" id="modalAviso" tabindex="-1" aria-labelledby="modalAvisoLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-warning text-white">
                    <h5 class="modal-title" id="modalAvisoLabel">
                        <i class="fas fa-exclamation-circle"></i> Aviso Importante
                    </h5>
                </div>
                <div class="modal-body text-center">
                    <p style="font-size: 1.1rem; font-weight: 500;">
                        <strong>Por favor, tenga en cuenta:</strong> <br>
                        Los datos personales ingresados deben coincidir exactamente con los que figuran en su documento
                        de identidad vigente.
                    </p>
                    <div class="mt-3">
                        <i class="fas fa-id-card-alt" style="font-size: 2.5rem; color: #ffc107;"></i>
                    </div>
                </div>
                <div class="modal-footer justify-content-center">
                    <button type="button" class="btn btn-primary btn-lg"
                        onclick="$('#modalAviso').modal('hide');">Entendido</button>
                </div>
            </div>
        </div>
    </div>
    <!-- Busquedas -->
    <?php echo $__env->make('busquedas.ubigeo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('busquedas.ubigeo_nacimiento', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/bootstrap-toggle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap-select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/datatables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/ficha-registro.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            const $contentLugarNacimiento = $("#content-lugar-nacimiento");
            const $contentDireccionLibre = $("#content-direccion-libre");
            const $lugar_nacimiento = $("#lugar_nacimiento");

            // Función para mostrar/ocultar contenido
            const toggleContent = (value) => {
                if (value === "00003") {
                    // Mostrar lugar de nacimiento y ocultar dirección libre
                    $lugar_nacimiento.slideDown(300, function() {
                        $contentDireccionLibre.slideUp(300);
                        $contentLugarNacimiento.slideDown(300);
                    });
                } else if (value !== "") {
                    // Mostrar dirección libre y ocultar lugar de nacimiento
                    $lugar_nacimiento.slideDown(300, function() {
                        $contentLugarNacimiento.slideUp(300);
                        $contentDireccionLibre.slideDown(300);
                    });
                } else {
                    // Ocultar ambos si no se selecciona nada
                    $contentLugarNacimiento.slideUp(300);
                    $contentDireccionLibre.slideUp(300);
                    $lugar_nacimiento.slideUp(300);
                }
            };

            // Detectar el valor inicial
            toggleContent($("#codi_pais_per").val());

            // Detectar cambios en el select
            $("#codi_pais_per").on("change", function() {
                const selectedValue = $(this).val();
                toggleContent(selectedValue);
            });
            $("#modalAviso").modal('show');

            $("#docentesdiv").show();
            $("#selec_disc").hide();
            $("#descripcion").hide();

            $("#si").click(function() {
                $("#selec_disc").show();
            });

            $("#seleccione_dis").click(function() {
                if ($("#seleccione_dis").val() == "OTROS") {
                    $("#descripcion").show();
                } else {
                    $("#descripcion").hide();
                }
            });

            $("#no").click(function() {
                $("#selec_disc").hide();
            });
            //------------------------------------------------------------------------------
            //Validar Tecnicas
            //------------------------------------------------------------------------------
            /*$("#escalas").change(function() {
                if ($("#escalas").val() != "S") {
                    $("#tecn_post_pos_esc").remove();
                } else {
                    $('#ecala_content').html(
                        '<textarea class="form-control col" id="tecn_post_pos_esc" placeholder="Describa sus Escalas" rows="3" name="tecn_post_pos_esc" autocomplete="nope"></textarea>'
                    );
                }
            });*/
            /*$("#estudios").change(function() {
                if ($("#estudios").val() != "S") {
                    $("#tecn_post_pos_est").remove();
                } else {
                    $('#estudios_content').html(
                        '<textarea class="form-control col" id="tecn_post_pos_est" placeholder="Describa sus Estudios" rows="3" name="tecn_post_pos_est" autocomplete="nope"></textarea>'
                    );
                }
            });*/
            //------------------------------------------------------------------------------
            //Validar Docente - Especialidad
            //------------------------------------------------------------------------------

            $("#tipo_prep_pos").change(function() {
                $("#codi_pers_per").prop("selected", false);
                $("#codi_espe_cex").prop("selected", false);
                if ($("#tipo_prep_pos").val() == "C") {
                    $("#docentes2div").hide();
                    $("#docentes1div").show();
                    $("#docentes1div2").show();
                } else if ($("#tipo_prep_pos").val() == "A" || $("#tipo_prep_pos").val() == "O") {
                    $("#docentes1div").hide();
                    $("#docentes1div2").hide();
                    $("#docentes2div").show();
                } else {
                    $("#docentes2div").hide();
                    $("#docentes1div").hide();
                    $("#docentes1div2").hide();
                }

            });

            //------------------------------------------------------------------------------
            //Validar seccion y grado
            //------------------------------------------------------------------------------

            $("#tipo_gra_esc").change(function() {
                $("#grad").prop("selected", false);
                if ($("#tipo_gra_esc").val() == "S") {
                    $("#grad").show();
                    $("#gra-sex").hide();
                } else if ($("#tipo_gra_esc").val() == "P") {

                    $("#grad").show();
                    $("#gra-sex").show();
                } else {
                    $("#grad").hide();
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php /**PATH C:\laragon\www\resources\views/inscripcion/ficha/edit.blade.php ENDPATH**/ ?>