<strong><?php echo e($titulo); ?></strong>
<button type="button" class="btn btn-primary" id="btnItem<?php echo e($titulo2); ?>Add" style="position:absolute; right:1.25rem;">
    <i class="fas fa-plus"></i><span class="d-none d-lg-inline-block pl-2">Agregar <?php echo e($titulo2); ?></span>
</button>
<br>
<div class="table-responsive mt-2">
    <table class="table table-sm table-bordered table-hover" id="table-<?php echo e($titulo2); ?>">
        <thead>
            <tr class="bg-light">
                <th>Compositor</th>
                <th><?php if($titulo=='Estudios'): ?>
                    Estudio
                <?php else: ?>
                    Obra
                <?php endif; ?></th>
                <th>Opciones</th>
            </tr>
        </thead>
        <tbody>
            
        </tbody>
    </table>
</div>

<div class="modal fade" aria-hidden="true" role="dialog" tabindex="-1" id="modal-<?php echo e($titulo2); ?>">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <strong><i class="fas fa-plus pr-2"></i>Agregar <?php echo e($titulo2); ?></strong>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body pb-0">
                <input type="hidden" id="codi_repe_rep">
                <div class="form-group row">
                    <label for="auto_repe_rep" class="text-md-right col-md-3">Compositor:</label>
                    <div class="col-md-9">
                        <input onkeypress="return event.charCode != 34" type="text" id="auto_repe_rep"
                            class="form-control" maxlength="100" autocomplete="nope">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="obra_repe_rep" class="text-md-right col-md-3"><?php if($titulo=='Estudios'): ?>
                    Estudio
                <?php else: ?>
                    Obra
                <?php endif; ?>:</label>
                    <div class="col-md-9">
                        <input onkeypress="return event.charCode != 34" type="text" id="obra_repe_rep"
                            class="form-control" maxlength="100" autocomplete="nope">
                    </div>
                </div>
            </div>
            <div class="modal-footer p-3">
                <button type="button" class="btn btn-primary" id="btnItem<?php echo e($titulo2); ?>OK">
                    <i class="fas fa-save pr-2"></i>Aceptar
                </button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-undo-alt pr-2"></i>Cancelar
                </button>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        // Agregar repertorio
        $('#btnItem<?php echo e($titulo2); ?>Add').click(function() {
            $('#modal-<?php echo e($titulo2); ?>').find('.modal-header').html(
                '<strong><i class="fas fa-plus pr-2"></i>Agregar <?php echo e($titulo2); ?></strong>');
            $('#modal-<?php echo e($titulo2); ?>').find('input:text, input:hidden').val('');
            $('#modal-<?php echo e($titulo2); ?>').modal({
                backdrop: 'static'
            });
        });

        // OK - Repertorio
        $('#btnItem<?php echo e($titulo2); ?>OK').click(function() {
            var tr = $('#table-<?php echo e($titulo2); ?>').find('.itemActive');
            var id = $.trim($('#modal-<?php echo e($titulo2); ?>').find('#codi_repe_rep').val());
            var autor = $.trim($('#modal-<?php echo e($titulo2); ?>').find('#auto_repe_rep').val());
            var obra = $.trim($('#modal-<?php echo e($titulo2); ?>').find('#obra_repe_rep').val());
            var data_ok = true;

            if (autor == '') {
                data_ok = false;
                alert('Debe especificar al compositor.');

            } else if (obra == '') {
                data_ok = false;
                alert('Debe especificar '+<?php if($titulo=='Estudios'): ?>'el Estudio.'<?php else: ?> 'la Obra.' <?php endif; ?>);

            }
            if (data_ok) {
                if (id.length > 0) {
                    tr.data('codi_repe_rep', id);
                    tr.data('auto_repe_rep', autor);
                    tr.data('obra_repe_rep', obra);
                    tr.children('td:eq(0)').text(autor);
                    tr.children('td:eq(1)').text(obra);

                } else {
                    var tr_html = '<tr data-codi_repe_rep="0"' +
                        'data-auto_repe_rep="' + autor + '"' +
                        'data-obra_repe_rep="' + obra + '"' + '>' +
                        '<td>' + autor + '</td>' +
                        '<td>' + obra + '</td>' +
                        '<td style="width:20%;">' +
                        '<button type="button" class="btn btn-info btn-sm btnItem<?php echo e($titulo2); ?>Edit">' +
                        '<i class="far fa-edit"></i><span class="d-none d-lg-inline-block pl-2">Editar</span>' +
                        '</button>' +
                        '<button type="button" class="btn btn-danger btn-sm btnRemoveItem">' +
                        '<i class="far fa-trash-alt"></i><span class="d-none d-lg-inline-block pl-2">Quitar</span>' +
                        '</button>' +
                        '</td>' +
                        '</tr>';

                    $('#table-<?php echo e($titulo2); ?> tbody').append(tr_html);
                }

                // Crea inputs
                $('.div-<?php echo e($titulo2); ?>').remove('');
                $('#table-<?php echo e($titulo2); ?> tbody tr').each(function(index) {
                    var input_html = '<div class="div-<?php echo e($titulo2); ?>">' +
                        '<input type="hidden" name="auto_repe_rep[]" value="' + $(this).data(
                            'auto_repe_rep') + '">' +
                        '<input type="hidden" name="obra_repe_rep[]" value="' + $(this).data(
                            'obra_repe_rep') + '">' +
                        '<input type="hidden" name="tipo_repe_rep[]" value="<?php echo e($titulo); ?>"></div>';

                    $('#table-<?php echo e($titulo2); ?> tbody').append(input_html);
                });

                $('#modal-<?php echo e($titulo2); ?>').modal('hide');
                $('#table-<?php echo e($titulo2); ?>').find('.itemActive').removeClass('itemActive');
            }
        });
    });
    // Editar repertorio
    $(document).on('click', '.btnItem<?php echo e($titulo2); ?>Edit', function(event) {
        event.preventDefault();
        var tr = $(this).closest('tr');

        $('#table-<?php echo e($titulo2); ?>').find('.itemActive').removeClass('itemActive');
        tr.addClass('itemActive');
        $('#modal-<?php echo e($titulo2); ?>').data('tr', tr.id);
        $('#modal-<?php echo e($titulo2); ?>').find('.modal-header').html(
            '<strong><i class="far fa-edit pr-2"></i>Editar <?php echo e($titulo2); ?></strong>');
        $('#modal-<?php echo e($titulo2); ?>').find('#codi_repe_rep').val(tr.data('codi_repe_rep'));
        $('#modal-<?php echo e($titulo2); ?>').find('#auto_repe_rep').val(tr.data('auto_repe_rep'));
        $('#modal-<?php echo e($titulo2); ?>').find('#obra_repe_rep').val(tr.data('obra_repe_rep'));
        $('#modal-<?php echo e($titulo2); ?>').modal({
            backdrop: 'static'
        });
    });
</script>
<?php /**PATH C:\laragon\www\resources\views/inscripcion/ficha/edit-repertory.blade.php ENDPATH**/ ?>