@extends('reportes.ficha.template')
@section('header')
    <img src="{{ asset('img/logo_cnm.png') }}">
@endsection

@section('content')
    <table border="0">
        <tr>
            <td width="180px">&nbsp;</td>
            <td width="10px">&nbsp;</td>
            <td width="200px">&nbsp;</td>
            <td width="10px">&nbsp;</td>
            <td width="120px">&nbsp;</td>
        </tr>
        <tr>
            <td colspan="3">
                <h3>FICHA DE INSCRIPCIÓN</h3>
            </td>
            <td rowspan="4"></td>
            <td rowspan="4"><img style="width:118px; border: 1px solid gray;"
                    src="{{ empty($postulacion->foto_post_per) ? asset('img/sin-foto.png') : asset('images/persons/' . $postulacion->foto_post_per) }}"
                    alt=""></td>
        </tr>
        <tr>
            <td class="td-right">Nº Expediente:</td>
            <td rowspan="3"></td>
            <td>
                {{ $postulacion->nume_expe_exp }}
            </td>
        </tr>
        <tr>
            <td class="td-right">Sección a la que postula:</td>
            <td>{{ $postulacion->seccion }}</td>
        </tr>
        <tr>
            <td class="td-right">Especialidad a la que postula:</td>
            <td>{{ $postulacion->especialidad }}</td>
        </tr>
        <tr>
            <td colspan="5">
                <h4>Datos Personales:</h4>
            </td>
        </tr>
        <tr>
            <td class="td-right">Apellido paterno:</td>
            <td rowspan="15"></td>
            <td colspan="3">{{ $postulacion->apel_pate_per }}</td>
        </tr>
        <tr>
            <td class="td-right">Apellido materno:</td>
            <td colspan="3">{{ $postulacion->apel_mate_per }}</td>
        </tr>
        <tr>
            <td class="td-right">Nombres:</td>
            <td colspan="3">{{ $postulacion->nomb_pers_per }}</td>
        </tr>
        <!-- sumarle al rowsoan la cant de filas -->
        <tr>
            <td class="td-right">País de nacimiento:</td>
            <td colspan="3">{{ $postulacion->pais }}</td>
        </tr>
        <tr>
            <td class="td-right">Fecha de nacimiento:</td>
            <td colspan="3">{{ date('d/m/Y', strtotime($postulacion->fech_naci_per)) }}</td>
        </tr>
        <tr>
            <td class="td-right">Lugar de Nacimiento:</td>
            <td colspan="3">
                @if ($postulacion->codi_pais_per == '0003')
                    {{ isset($ubigeoNac->nomb_depa_ubg) ? $ubigeoNac->nomb_depa_ubg . ', ' . $ubigeoNac->nomb_prov_ubg . ', ' . $ubigeoNac->nomb_dist_ubg : '' }}
                @else
                    {{ $postulacion->direccion_libre }}
                @endif
            </td>
        </tr>
        <tr>
            <td class="td-right">Edad:</td>
            <td colspan="3">{{ $postulacion->edad_calc_pos }} años</td>
        </tr>
        <tr>
            <td class="td-right">Lugar de residencia:</td>
            <td colspan="3">
                {{ isset($ubigeoDom->nomb_depa_ubg) ? $ubigeoDom->nomb_depa_ubg . ', ' . $ubigeoDom->nomb_prov_ubg . ', ' . $ubigeoDom->nomb_dist_ubg : '' }}
            </td>
        </tr>
        <tr>
            <td class="td-right">Teléfono celular:</td>
            <td colspan="3">{{ $postulacion->telf_celu_per }}</td>
        </tr>
        <tr>
            <td class="td-right">Teléfono fijo:</td>
            <td colspan="3">{{ $postulacion->telf_fijo_per }}</td>
        </tr>
        <tr>
            <td class="td-right">Correo electrónico:</td>
            <td colspan="3">{{ $postulacion->mail }}</td>
        </tr>
        {{--		<tr>
				<td class="td-right">Correpetidor:</td>
				<td colspan="3">{{ $postulacion->nomb_corr_pos }}</td>
		</tr> --}}
        <tr>
            <td class="td-right">Lugar dónde se preparó:</td>
            <td colspan="3">
                {{ $postulacion->tipo_prep_pos == 'C' ? 'Cursos de extensión' : ($postulacion->tipo_prep_pos == 'A' ? 'Academia' : 'Otro') }}
            </td>
        </tr>
        <tr>
            <td class="td-right">Especialidad / profesor:</td>
            <td colspan="3">
                @if ($postulacion->tipo_prep_pos == 'C')
                    {{ $especialidad_estudio . ' / ' . $profesor }}<br>
                @endif
                {{ $postulacion->desc_prep_pos }}
            </td>

        </tr>
        @if ($postulacion->codi_secc_sec == '05003')
            <tr>
                <td class="td-right">Nivel de Estudio:</td>
                <td colspan="3">
                    @if ($postulacion->nive_estu_adm == 'P')
                        Primaria
                    @elseif($postulacion->nive_estu_adm == 'S')
                        Secundaria
                    @endif
                </td>
            </tr>
            <tr>
                <td class="td-right">Grado de Estudio:</td>
                <td colspan="3"> @switch($postulacion->grad_estu_adm)
                        @case(1)
                            Primero
                        @break

                        @case(2)
                            Segundo
                        @break

                        @case(3)
                            Tercero
                        @break

                        @case(4)
                            Cuarto
                        @break

                        @case(5)
                            Quinto
                        @break

                        @case(6)
                            Sexto
                        @break
                    @endswitch
                    Grado </td>
            </tr>
        @endif
        @if ($postulacion->flag_disc_adm == 'S')
            <tr>
                <td class="td-right">Discapacidad:</td>
                <td colspan="3">{{ $postulacion->disc_soli_adm }}</td>
            </tr>
        @endif
        @if ($postulacion->subd_moda_pos)
            <tr>
                <td class="td-right">Condicion:</td>
                <td colspan="3">{{ $postulacion->subd_moda_pos }}</td>
            </tr>
        @endif
        @if ($postulacion->edad_calc_pos < 18)
            <tr>
                <td colspan="5">
                    <h4>Datos del Padre o Apoderado:</h4>
                </td>
            </tr>
            <tr>
                <td class="td-right">Apellidos y nombres:</td>
                <td rowspan="3"></td>
                <td colspan="3">{{ $postulacion->apel_nomb_apd }}</td>
            </tr>
            <tr>
                <td class="td-right">DNI:</td>
                <td colspan="3">{{ $postulacion->nume_docu_apd }}</td>
            </tr>
            <tr>
                <td class="td-right">Teléfono:</td>
                <td colspan="3">{{ $postulacion->telf_fijo_apd }}</td>
            </tr>
        @endif
    </table>
    <!-- 2021 -->

    <p style="page-break-before:always;"></p>
    <h3>FICHA DE REPERTORIO Y/O TRABAJOS A PRESENTAR</h3>
    <table border="0">
        <tr>
            <td class="td-right">Documento de identidad:</td>
            <td>{{ $postulacion->abre_tipo_doc . '  ' . $postulacion->nume_docu_per }}</td>
        </tr>
        <tr>
            <td class="td-right">Nº Expediente:</td>
            <td>{{ $postulacion->nume_expe_exp }}</td>
        </tr>
        <tr>
            <td class="td-right">Lugar dónde se preparó:</td>
            <td>{{ $postulacion->tipo_prep_pos == 'C' ? 'Cursos de extensión' : ($postulacion->tipo_prep_pos == 'A' ? 'Academia' : 'Otro') }}
            </td>
        </tr>
        <tr>
            <td class="td-right">Especialidad / profesor:</td>
            <td>
                @if ($postulacion->tipo_prep_pos == 'C')
                    {{ $especialidad_estudio . ' / ' . $profesor }}
                    <br>
                @endif
                {{ $postulacion->desc_prep_pos }}
            </td>
        </tr>
    </table>
    <br>
    <span>INTERPRETACIÓN (Estudios y repertorio, se detalla movimientos o secciones)</span>
    <table style="width: 100%; border-collapse: collapse; font-size: 12px; table-layout: fixed;">
    <tr>
        <td style="width: 50px;">&nbsp;</td>
        <td style="width: 200px;">&nbsp;</td>
        <td style="width: 200px;">&nbsp;</td>
        <td style="width: 120px;">&nbsp;</td>
    </tr>
    <tr>
        <th colspan="4" style="background-color: #d6d6d6; text-align: center; padding: 5px;">
            TÉCNICA: Escalas y Estudios
        </th>
    </tr>
    <tr>
        <td colspan="4" style="padding: 5px;">
            @foreach (explode('</br>', $postulacion->tecn_post_pos) as $k => $v)
                <div style="word-wrap: break-word;">
                    <p style="margin: 0;">{{ $v }}</p>
                </div>
            @endforeach
        </td>
    </tr>
    <tr>
        <td colspan="4">&nbsp;</td>
    </tr>

    @foreach ($repertorio as $tipo => $elementos)
        <tr>
            <th colspan="4" style="background-color: #d6d6d6; text-align: center; padding: 5px;">
                {{ trim($tipo) !== '' ? $tipo : 'REPERTORIO' }}
            </th>
        </tr>
        <tr>
            <th style="width: 10%; text-align: center; padding: 5px;">Nº</th>
            <th style="width: 45%; text-align: center; padding: 5px;">COMPOSITOR</th>
            <th style="width: 45%; text-align: center; padding: 5px;">
                @if ($tipo == 'Estudios')
                    ESTUDIO
                @else
                    OBRA
                @endif
            </th>
        </tr>
        @foreach ($elementos as $index => $element)
            <tr>
                <td style="text-align: center; padding: 5px;">{{ $index + 1 }}</td>
                <td style="text-align: left; padding: 5px; word-wrap: break-word;">{{ $element->auto_repe_rep }}</td>
                <td style="text-align: left; padding: 5px; word-wrap: break-word;">{{ $element->obra_repe_rep }}</td>
            </tr>
        @endforeach
    @endforeach
</table>

    <!-- 2021 -->
@endsection
@section('footer')
    <span>&copy; {{ date('Y') }} Conservatorio Nacional de M&uacute;sica. Todos los derechos reservados.</span>
@endsection
