<strong>{{ $titulo }}</strong>
<button type="button" class="btn btn-primary" id="btnItem{{ $titulo2 }}Add" style="position:absolute; right:1.25rem;">
    <i class="fas fa-plus"></i><span class="d-none d-lg-inline-block pl-2">Agregar {{ $titulo2 }}</span>
</button>
<br>
<div class="table-responsive mt-2">
    <table class="table table-sm table-bordered table-hover" id="table-{{ $titulo2 }}">
        <thead>
            <tr class="bg-light">
                <th>Compositor</th>
                <th>@if ($titulo=='Estudios')
                    Estudio
                @else
                    Obra
                @endif</th>
                <th>Opciones</th>
            </tr>
        </thead>
        <tbody>
            {{--@foreach ($repertorio as $index => $rep)
                <tr data-codi_repe_rep="{{ $rep->codi_repe_rep }}" data-auto_repe_rep="{{ $rep->auto_repe_rep }}"
                    data-obra_repe_rep="{{ $rep->obra_repe_rep }}">
                    <td>{{ $rep->auto_repe_rep }}</td>
                    <td>{{ $rep->obra_repe_rep }}</td>
                    <td style="width:20%;">
                        <button type="button" class="btn btn-info btn-sm btnItem{{ $titulo2 }}Edit">
                            <i class="far fa-edit"></i><span class="d-none d-lg-inline-block pl-2">Editar</span>
                        </button>
                        <button type="button" class="btn btn-danger btn-sm btnRemoveItem">
                            <i class="far fa-trash-alt"></i><span class="d-none d-lg-inline-block pl-2">Quitar</span>
                        </button>
                    </td>
                </tr>

                <div class="div-{{ $titulo2 }}">
                    <input type="hidden" name="auto_repe_rep[]" value="{{ $rep->auto_repe_rep }}">
                    <input type="hidden" name="obra_repe_rep[]" value="{{ $rep->obra_repe_rep }}">
                    <input type="hidden" name="tipo_repe_rep[]" value="{{ $titulo }}">
                </div>
            @endforeach--}}
        </tbody>
    </table>
</div>

<div class="modal fade" aria-hidden="true" role="dialog" tabindex="-1" id="modal-{{ $titulo2 }}">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-primary">
                <strong><i class="fas fa-plus pr-2"></i>Agregar {{ $titulo2 }}</strong>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body pb-0">
                <input type="hidden" id="codi_repe_rep">
                <div class="form-group row">
                    <label for="auto_repe_rep" class="text-md-right col-md-3">Compositor:</label>
                    <div class="col-md-9">
                        <input onkeypress="return event.charCode != 34" type="text" id="auto_repe_rep"
                            class="form-control" maxlength="100" autocomplete="nope">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="obra_repe_rep" class="text-md-right col-md-3">@if ($titulo=='Estudios')
                    Estudio
                @else
                    Obra
                @endif:</label>
                    <div class="col-md-9">
                        <input onkeypress="return event.charCode != 34" type="text" id="obra_repe_rep"
                            class="form-control" maxlength="100" autocomplete="nope">
                    </div>
                </div>
            </div>
            <div class="modal-footer p-3">
                <button type="button" class="btn btn-primary" id="btnItem{{ $titulo2 }}OK">
                    <i class="fas fa-save pr-2"></i>Aceptar
                </button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    <i class="fas fa-undo-alt pr-2"></i>Cancelar
                </button>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        // Agregar repertorio
        $('#btnItem{{ $titulo2 }}Add').click(function() {
            $('#modal-{{ $titulo2 }}').find('.modal-header').html(
                '<strong><i class="fas fa-plus pr-2"></i>Agregar {{ $titulo2 }}</strong>');
            $('#modal-{{ $titulo2 }}').find('input:text, input:hidden').val('');
            $('#modal-{{ $titulo2 }}').modal({
                backdrop: 'static'
            });
        });

        // OK - Repertorio
        $('#btnItem{{ $titulo2 }}OK').click(function() {
            var tr = $('#table-{{ $titulo2 }}').find('.itemActive');
            var id = $.trim($('#modal-{{ $titulo2 }}').find('#codi_repe_rep').val());
            var autor = $.trim($('#modal-{{ $titulo2 }}').find('#auto_repe_rep').val());
            var obra = $.trim($('#modal-{{ $titulo2 }}').find('#obra_repe_rep').val());
            var data_ok = true;

            if (autor == '') {
                data_ok = false;
                alert('Debe especificar al compositor.');

            } else if (obra == '') {
                data_ok = false;
                alert('Debe especificar '+@if ($titulo=='Estudios')'el Estudio.'@else 'la Obra.' @endif);

            }
            if (data_ok) {
                if (id.length > 0) {
                    tr.data('codi_repe_rep', id);
                    tr.data('auto_repe_rep', autor);
                    tr.data('obra_repe_rep', obra);
                    tr.children('td:eq(0)').text(autor);
                    tr.children('td:eq(1)').text(obra);

                } else {
                    var tr_html = '<tr data-codi_repe_rep="0"' +
                        'data-auto_repe_rep="' + autor + '"' +
                        'data-obra_repe_rep="' + obra + '"' + '>' +
                        '<td>' + autor + '</td>' +
                        '<td>' + obra + '</td>' +
                        '<td style="width:20%;">' +
                        '<button type="button" class="btn btn-info btn-sm btnItem{{ $titulo2 }}Edit">' +
                        '<i class="far fa-edit"></i><span class="d-none d-lg-inline-block pl-2">Editar</span>' +
                        '</button>' +
                        '<button type="button" class="btn btn-danger btn-sm btnRemoveItem">' +
                        '<i class="far fa-trash-alt"></i><span class="d-none d-lg-inline-block pl-2">Quitar</span>' +
                        '</button>' +
                        '</td>' +
                        '</tr>';

                    $('#table-{{ $titulo2 }} tbody').append(tr_html);
                }

                // Crea inputs
                $('.div-{{ $titulo2 }}').remove('');
                $('#table-{{ $titulo2 }} tbody tr').each(function(index) {
                    var input_html = '<div class="div-{{ $titulo2 }}">' +
                        '<input type="hidden" name="auto_repe_rep[]" value="' + $(this).data(
                            'auto_repe_rep') + '">' +
                        '<input type="hidden" name="obra_repe_rep[]" value="' + $(this).data(
                            'obra_repe_rep') + '">' +
                        '<input type="hidden" name="tipo_repe_rep[]" value="{{ $titulo }}"></div>';

                    $('#table-{{ $titulo2 }} tbody').append(input_html);
                });

                $('#modal-{{ $titulo2 }}').modal('hide');
                $('#table-{{ $titulo2 }}').find('.itemActive').removeClass('itemActive');
            }
        });
    });
    // Editar repertorio
    $(document).on('click', '.btnItem{{ $titulo2 }}Edit', function(event) {
        event.preventDefault();
        var tr = $(this).closest('tr');

        $('#table-{{ $titulo2 }}').find('.itemActive').removeClass('itemActive');
        tr.addClass('itemActive');
        $('#modal-{{ $titulo2 }}').data('tr', tr.id);
        $('#modal-{{ $titulo2 }}').find('.modal-header').html(
            '<strong><i class="far fa-edit pr-2"></i>Editar {{ $titulo2 }}</strong>');
        $('#modal-{{ $titulo2 }}').find('#codi_repe_rep').val(tr.data('codi_repe_rep'));
        $('#modal-{{ $titulo2 }}').find('#auto_repe_rep').val(tr.data('auto_repe_rep'));
        $('#modal-{{ $titulo2 }}').find('#obra_repe_rep').val(tr.data('obra_repe_rep'));
        $('#modal-{{ $titulo2 }}').modal({
            backdrop: 'static'
        });
    });
</script>
