<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class FichaFormRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    //2021 Se comentó técnica
    //2023 Se descomentó técnica
    public function rules()
    {
        return [
            'apel_pate_per' => 'max:30|required',
            'apel_mate_per' => 'required|max:30',
            'nomb_pers_per' => 'required|max:40',
            'codi_pais_per' => 'required',
            ////////////2024/////////////////
            'ubig_naci_per' => 'required_if:codi_pais_per,00003',
            'direccion_libre' => 'required_unless:codi_pais_per,00003',
            /////////////////////////////////
            'foto_post_per' => 'nullable|image|max:3072',
            'file_docu_pos' => 'nullable|image|max:3072',
            'arch_foto_per' => 'foto_postulante:submit,foto_post_per',
            'arch_docu_per' => 'foto_postulante:submit,file_docu_pos',
            'ubig_domi_per' => 'required|min:6',
            'telf_fijo_per' => 'required_at_least_one:telf_celu_per|max:20',
            'tipo_prep_pos' => 'required',
            //'codi_doce_adm' => 'required_if:tipo_prep_pos,==,C',
            'codi_espe_adm' => 'required_if:tipo_prep_pos,==,C',
            //'leng_musi_per' => 'required_if:tipo_prep_pos,==,C',
            'desc_prep_pos' => 'required_unless:tipo_prep_pos,C|max:150',
            'nive_estu_adm' => 'required_unless:codi_secc_sec,05001',
            'grad_estu_adm' => 'required_unless:codi_secc_sec,05001',
            'flag_disc_adm' => 'required',
            'disc_soli_adm' => 'required_if:flag_disc_adm,==,S',
            'nomb_corr_pos' => 'required_if:flag_corr_pos,==,S|max:150',
            'apel_nomb_apd' => 'required_if_underage:edad_calc_pos|max:150',
            'telf_fijo_apd' => 'required_if_underage:edad_calc_pos|max:20',
            'nume_docu_apd' => 'required_if_underage:edad_calc_pos|digits:8',
            //'tecn_post_pos'=>'required|max:1000',
            //'escalas' => 'required',
            //'estudios' => 'required',
            //'tecn_post_pos_esc' => 'required_if:escalas,S',
            'tecn_post_pos_esc' => 'required',
            'checkbox1' => 'required',
            'auto_repe_rep' => 'required',
            //'tecn_post_pos_est' => 'required_if:estudios,S',
        ];
    }

    //2021 Se comentó técnica
    //2023 Se descomentó técnica
    public function messages()
    {
        return [
            'apel_mate_per.required' => 'Debe completar el campos Apellido Materno',
            'apel_pate_per.required' => 'Debe completar el campos Apellido Paterno',
            'nomb_pers_per.required' => 'Debe completar el campos Nombres',
            'ubig_domi_per.*' => 'Debe seleccionar su lugar de residencia.',
            'arch_foto_per.foto_postulante' => 'Debe seleccionar una fotografía.',
            'codi_pais_per.required' => 'Debe especificar un Pais de Nacimiento.',
            'file_docu_pos.mimes' => 'La imagen de su docmento de identidad debe ser un archivo con formato: jpg, png.',
            'foto_post_per.mimes' => 'La imagen de la foto de perfil debe ser un archivo con formato: jpg, png.',
            'arch_docu_per.foto_postulante' => 'Debe seleccionar una fotografía del documento de identidad.',
            'foto_post_per.*' => 'La fotografía debe ser una imagen válida con un peso máximo de 3MB.',
            'file_docu_pos.*' => 'La fotografía del documento de identidad debe ser una imagen válida con un peso máximo de 3MB.',
            'telf_fijo_per.required_at_least_one' => 'Debe especificar su teléfono fijo o teléfono celular.',
            'nomb_corr_pos.required_if' => 'Al indicar que requiere correpetidor, debe especificar el nombre.',
            'apel_nomb_apd.required_if_underage' => 'Debe especificar los nombres y apellidos del apoderado.',
            'telf_fijo_apd.required_if_underage' => 'Debe especificar el teléfono del apoderado.',
            'nume_docu_apd.required_if_underage' => 'Debe especificar el DNI del apoderado.',
            'nume_docu_apd.digits' => 'El DNI del apoderado debe tener 8 dígitos.',
            //'tecn_post_pos.required'=>'El campo técnica es obligatorio.',
            'desc_prep_pos.required_unless' => 'Debe especificar Dónde se preparó.',
            'nive_estu_adm.required_unless' => 'Debe especificar el Nivel de estudio.',
            'grad_estu_adm.required_unless' => 'Debe especificar el Grado de estudio.',

            'tipo_prep_pos.required' => 'Debe especificar Dónde se preparó.',
            'auto_repe_rep.required' => 'Debe ingresar datos en su Ficha de Examen de Especialidad.',
            'codi_doce_adm.required_if' => 'Debe especificar el Docente que lo preparó.', //
            'leng_musi_per.required_if' => 'Debe especificar el Docente que lo preparó.', //
            'codi_espe_adm.required_if' => 'Debe especificar la Especialidad de la preparación.',
            'arch_foto_per.mimes' => 'La imagen de perfil debe ser un archivo con formato: jpg, png.',
            'flag_disc_adm.required' => 'Debe especificar si cuenta con  alguna discapacidad.',
            'disc_soli_adm.required_if' => 'Debe especificar su discapacidad.',
            'escalas.required' => 'Debe completar los campos de la Sección escalas.',
            'estudios.required' => 'Debe completar los campos de la Sección estudios.',
            'tecn_post_pos_esc.required' => 'Debe especificar el campo de Escalas y arpegios.',
            'tecn_post_pos_est.required_if' => 'Debe completar los campos de la Sección estudios.',
            ////////////2024/////////////////
            // Validaciones condicionales para codi_pais_per
            'ubig_naci_per.required_if' => 'Debe especificar el lugar de nacimiento.',
            'direccion_libre.required_unless' => 'Debe especificar el lugar de nacimiento direccion_libre.',
            /////////////////////////////////
        ];
    }

    //2021 Se comentó técnica
    //2023 Se descomentó técnica
    public function attributes()
    {
        return [
            'apel_pate_per' => 'apellido paterno',
            'apel_mate_per' => 'apellido materno',
            'nomb_pers_per' => 'nombres',
            'codi_pais_per' => 'país',
            'foto_post_per' => 'fotografía del postulante',
            'file_docu_pos' => 'fotografía del documento del postulante',
            'ubig_domi_per' => 'lugar de residencia',
            'telf_fijo_per' => 'teléfono fijo',
            'telf_celu_per' => 'teléfono celular',
            'tipo_prep_pos' => 'tipo de preparación',
            'desc_prep_pos' => 'Lugar donde se preparó',
            'nomb_corr_pos' => 'nombre del correpetidor',
            'apel_nomb_apd' => 'nombres y apellidos del apoderado',
            'telf_fijo_apd' => 'teléfono del apoderado',
            'nume_docu_apd' => 'DNI del apoderado',
            'codi_doce_adm' => 'Docente de especialidad',
            'leng_musi_per' => 'Docente de Lenguaje Musical',
            //'tecn_post_pos'=>'técnica',
            'flag_disc_adm' => 'Cuenta con Discapacidad',
            'disc_soli_adm' => 'Discapacidad',
            'arch_foto_per' => 'fotografía del postulante',
            'arch_docu_per' => 'fotografía del documento del postulante',
            'nive_estu_adm' => 'Nivel de Estudios',
            'grad_estu_adm' => 'Grado de Estudios',
            'tecn_post_pos_esc' => 'Escalas y arpegios'
        ];
    }
}
