<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>Sistema de Eventos – Universidad Nacional de Música</title>

    {{-- Bootstrap (puedes usar el que ya tengas en el proyecto) --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css">

    {{-- EventCalendar --}}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@event-calendar/build@4.7.1/dist/event-calendar.min.css">
    <script src="https://cdn.jsdelivr.net/npm/@event-calendar/build@4.7.1/dist/event-calendar.min.js"></script>

    <style>
        body {
            background-color: #f3f4f6;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
        }

        .navbar-unm {
            background: #4b2f7f;
            /* puedes ajustar al color institucional real */
        }

        .navbar-unm .navbar-brand,
        .navbar-unm .nav-link,
        .navbar-unm .navbar-text {
            color: #fff !important;
        }

        .sidebar {
            background: #111827;
            min-height: 100vh;
            color: #e5e7eb;
        }

        .sidebar .nav-link {
            color: #9ca3af;
        }

        .sidebar .nav-link.active,
        .sidebar .nav-link:hover {
            color: #fff;
            background: #1f2937;
        }

        .content-wrapper {
            padding: 20px;
        }

        .card-metric {
            border-radius: 12px;
            border: none;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
        }

        .calendar-container {
            border-radius: 12px;
            border: 1px solid #e5e7eb;
            background: #fff;
            padding: 10px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
        }

        #eventcalendar {
            height: 700px;
        }

        .filter-bar .form-control,
        .filter-bar .custom-select {
            font-size: 0.9rem;
        }

        .badge-estado {
            font-size: 0.8rem;
        }

        /* Modal scroll */
        .modal-body {
            max-height: 60vh;
            overflow-y: auto;
        }
    </style>
</head>

<body>

    <nav class="navbar navbar-expand-lg navbar-unm">
        <a class="navbar-brand" href="#">
            {{-- Aquí puedes poner el logo real de la UNM --}}
            <strong>UNM</strong> – Sistema de Eventos
        </a>
        <div class="ml-auto navbar-text">
            {{ auth()->user()->name ?? 'Usuario Invitado' }}
        </div>
    </nav>

    <div class="container-fluid">
        <div class="row">
            {{-- SIDEBAR --}}
            <div class="col-md-2 sidebar py-3">
                <h6 class="text-uppercase text-muted px-3 mb-3" style="font-size: 0.75rem;">
                    Menú
                </h6>
                <nav class="nav flex-column">
                    <a href="#" class="nav-link active">Calendario institucional</a>
                    <a href="#" class="nav-link">Eventos</a>
                    <a href="#" class="nav-link">Espacios y recursos</a>
                    <a href="#" class="nav-link">Logística y gastos</a>
                    <a href="#" class="nav-link">Reportes</a>
                    <a href="#" class="nav-link">Configuración</a>
                </nav>
            </div>

            {{-- CONTENIDO PRINCIPAL --}}
            <div class="col-md-10 content-wrapper">

                {{-- Encabezado --}}
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <div>
                        <h4 class="mb-0">Calendario de Eventos</h4>
                        <small class="text-muted">
                            Universidad Nacional de Música – Recitales, conciertos, talleres y actividades académicas
                        </small>
                    </div>
                    <div>
                        <button class="btn btn-primary btn-sm">
                            <span class="mr-1">➕</span> Nuevo evento
                        </button>
                    </div>
                </div>

                {{-- Métricas rápidas --}}
                <div class="row mb-3">
                    <div class="col-md-3 mb-2">
                        <div class="card card-metric">
                            <div class="card-body">
                                <small class="text-muted text-uppercase">Eventos este mes</small>
                                <h4 class="mt-2 mb-0" id="metric-eventos-mes">12</h4>
                                <small class="text-muted">Incluye recitales, conciertos y talleres</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="card card-metric">
                            <div class="card-body">
                                <small class="text-muted text-uppercase">Eventos hoy</small>
                                <h4 class="mt-2 mb-0" id="metric-eventos-hoy">3</h4>
                                <small class="text-muted">Auditorio principal, Sala 201 y Aula 304</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="card card-metric">
                            <div class="card-body">
                                <small class="text-muted text-uppercase">Aforo total hoy</small>
                                <h4 class="mt-2 mb-0" id="metric-aforo-hoy">280</h4>
                                <small class="text-muted">Capacidad máxima de los eventos del día</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-2">
                        <div class="card card-metric">
                            <div class="card-body">
                                <small class="text-muted text-uppercase">Gasto estimado mes</small>
                                <h4 class="mt-2 mb-0" id="metric-gasto-mes">S/ 8,500</h4>
                                <small class="text-muted">Entre logística, alquileres y honorarios</small>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Filtros + Calendario --}}
                <div class="calendar-container mb-4">

                    {{-- Filtros superiores --}}
                    <div class="filter-bar mb-3">
                        <form class="form-row">
                            <div class="col-md-2 mb-2">
                                <label class="small mb-1">Sede</label>
                                <select class="custom-select custom-select-sm" id="filtro-sede">
                                    <option value="">Todas</option>
                                    <option value="Sede Histórica">Sede Histórica</option>
                                    <option value="Sede Anexa">Sede Anexa</option>
                                </select>
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="small mb-1">Espacio</label>
                                <select class="custom-select custom-select-sm" id="filtro-espacio">
                                    <option value="">Todos</option>
                                    <option value="Auditorio Principal">Auditorio Principal</option>
                                    <option value="Sala 201">Sala 201</option>
                                    <option value="Aula 304">Aula 304</option>
                                </select>
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="small mb-1">Tipo de evento</label>
                                <select class="custom-select custom-select-sm" id="filtro-tipo">
                                    <option value="">Todos</option>
                                    <option value="Recital">Recital</option>
                                    <option value="Concierto">Concierto</option>
                                    <option value="Taller">Taller</option>
                                    <option value="Clase maestra">Clase maestra</option>
                                </select>
                            </div>
                            <div class="col-md-2 mb-2">
                                <label class="small mb-1">Estado</label>
                                <select class="custom-select custom-select-sm" id="filtro-estado">
                                    <option value="">Todos</option>
                                    <option value="aprobado">Aprobado</option>
                                    <option value="publicado">Publicado</option>
                                    <option value="realizado">Realizado</option>
                                </select>
                            </div>
                            <div class="col-md-2 mb-2 d-flex align-items-end">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" id="filtro-mis-eventos">
                                    <label class="form-check-label small" for="filtro-mis-eventos">
                                        Solo mis eventos
                                    </label>
                                </div>
                            </div>
                        </form>
                    </div>

                    {{-- Contenedor del calendario --}}
                    <div id="eventcalendar"></div>
                </div>

            </div>
        </div>
    </div>

    {{-- Modal de detalle de evento --}}
    <div class="modal fade" id="modalDetalleEvento" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        Detalle del evento
                    </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    {{-- Aquí llenaremos con JS los datos del evento --}}
                    <div id="detalle-evento-contenido">
                        <p>Cargando información del evento...</p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-outline-secondary btn-sm" data-dismiss="modal">Cerrar</button>
                    <button class="btn btn-primary btn-sm">Ver ficha completa</button>
                </div>
            </div>
        </div>
    </div>

    {{-- JS de Bootstrap --}}
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var ecEl = document.getElementById('eventcalendar');

            // Eventos de ejemplo (luego esto vendrá de /api/eventos-calendario)
            var eventosDemo = [{
                    id: 1,
                    title: 'Recital de piano – Auditorio Principal',
                    start: '2025-11-20T19:00:00',
                    end: '2025-11-20T21:00:00',
                    sede: 'Sede Histórica',
                    espacio: 'Auditorio Principal',
                    tipo: 'Recital',
                    estado: 'publicado',
                    aforo_maximo: 150,
                    descripcion: 'Recital de piano a cargo de estudiantes de la especialidad de Piano.',
                    organizador: 'Departamento de Piano'
                },
                {
                    id: 2,
                    title: 'Ensayo Orquesta Sinfónica',
                    start: '2025-11-22T09:00:00',
                    end: '2025-11-22T12:00:00',
                    sede: 'Sede Histórica',
                    espacio: 'Sala 201',
                    tipo: 'Ensayo',
                    estado: 'aprobado',
                    aforo_maximo: 80,
                    descripcion: 'Ensayo general previo al concierto sinfónico.',
                    organizador: 'Dirección de Orquesta'
                },
                {
                    id: 3,
                    title: 'Clase maestra de Violín',
                    start: '2025-11-25T16:00:00',
                    end: '2025-11-25T18:00:00',
                    sede: 'Sede Anexa',
                    espacio: 'Aula 304',
                    tipo: 'Clase maestra',
                    estado: 'publicado',
                    aforo_maximo: 40,
                    descripcion: 'Clase maestra dictada por docente invitado internacional.',
                    organizador: 'Departamento de Cuerdas'
                },
                {
                    id: 4,
                    title: 'Concierto de música de cámara',
                    start: '2025-11-28T18:00:00',
                    end: '2025-11-28T20:00:00',
                    sede: 'Sede Histórica',
                    espacio: 'Auditorio Principal',
                    tipo: 'Concierto',
                    estado: 'publicado',
                    aforo_maximo: 120,
                    descripcion: 'Presentación de ensambles de cámara de diferentes ciclos.',
                    organizador: 'Coordinación Académica'
                }
            ];

            var ec = EventCalendar.create(ecEl, {
                view: 'timeGridWeek',
                locale: 'es',
                headerToolbar: {
                    start: 'prev,next today',
                    center: 'title',
                    end: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
                },
                slotMinTime: '08:00:00',
                slotMaxTime: '22:00:00',
                events: eventosDemo,
                eventClick: function(info) {
                    // info.event contiene los datos clickeados
                    var e = info.event.extendedProps;
                    var title = info.event.title;

                    var html = `
                    <h5>${title}</h5>
                    <p>
                        <span class="badge badge-primary badge-estado">${e.tipo || 'Evento'}</span>
                        <span class="badge badge-info badge-estado">${e.estado || ''}</span>
                    </p>
                    <p><strong>Fecha y hora:</strong><br>
                        ${info.event.start.toLocaleString()} – ${info.event.end ? info.event.end.toLocaleString() : ''}
                    </p>
                    <p><strong>Sede y espacio:</strong><br>
                        ${e.sede || '-'} – ${e.espacio || '-'}
                    </p>
                    <p><strong>Organizador:</strong><br>
                        ${e.organizador || '-'}
                    </p>
                    <p><strong>Aforo máximo:</strong><br>
                        ${e.aforo_maximo || '-'} personas
                    </p>
                    <p><strong>Descripción:</strong><br>
                        ${e.descripcion || 'Sin descripción registrada.'}
                    </p>
                `;

                    document.getElementById('detalle-evento-contenido').innerHTML = html;
                    $('#modalDetalleEvento').modal('show');
                }
            });

            // Más adelante aquí puedes agregar lógica para filtrar eventos
            // según los select (sede, espacio, tipo, estado, mis eventos, etc.)
        });
    </script>

</body>

</html>
