<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterEventosUsuariosForAuth extends Migration
{
    public function up(): void
    {
        Schema::table('eventos.usuarios', function (Blueprint $table) {
            // correo verificado (opcional)
            $table->timestamp('email_verified_at')->nullable()->after('email');

            // token para "recordarme" en login
            $table->rememberToken();
        });
    }

    public function down(): void
    {
        Schema::table('eventos.usuarios', function (Blueprint $table) {
            $table->dropColumn(['email_verified_at', 'remember_token']);
        });
    }
}
