<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Rol extends Model
{
    protected $table = 'eventos.roles';

    public $timestamps = false; // nuestra tabla roles no tiene created_at/updated_at

    protected $fillable = [
        'nombre',
        'descripcion',
    ];

    public function usuarios()
    {
        return $this->hasMany(User::class, 'rol_id');
    }
}
