<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Persona extends Model
{
    protected $table = 'eventos.personas';

    public $timestamps = false;

    protected $fillable = [
        'nombres',
        'apellidos',
        'tipo_persona',
        'documento',
        'correo',
        'telefono',
        'especialidad',
        'es_interno',
        'activo',
    ];

    public function usuarios()
    {
        return $this->hasMany(User::class, 'persona_id');
    }
}
